/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.GlobalTrackedPortal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class WorldWrappingPortal
extends GlobalTrackedPortal {
    public boolean isInward = true;
    public int zoneId = -1;

    public WorldWrappingPortal(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("isInward")) {
            this.isInward = compoundTag.m_128471_("isInward");
        }
        if (compoundTag.m_128441_("zoneId")) {
            this.zoneId = compoundTag.m_128451_("zoneId");
        }
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("isInward", this.isInward);
        compoundTag.m_128405_("zoneId", this.zoneId);
    }

    private static WorldWrappingPortal createWrappingPortal(ServerLevel serverWorld, AABB area, Direction direction, int zoneId, boolean isInward) {
        WorldWrappingPortal portal = (WorldWrappingPortal)((EntityType)IPRegistry.BORDER_PORTAL.get()).m_20615_((Level)serverWorld);
        portal.isInward = isInward;
        portal.zoneId = zoneId;
        WorldWrappingPortal.initWrappingPortal(serverWorld, area, direction, isInward, portal);
        return portal;
    }

    public static void initWrappingPortal(ServerLevel serverWorld, AABB area, Direction direction, boolean isInward, Portal portal) {
        Vec3 areaSize = Helper.getBoxSize(area);
        Tuple<Direction, Direction> axises = Helper.getPerpendicularDirections(isInward ? direction : direction.m_122424_());
        AABB boxSurface = Helper.getBoxSurfaceInversed(area, direction);
        Vec3 center = boxSurface.m_82399_();
        AABB oppositeSurface = Helper.getBoxSurfaceInversed(area, direction.m_122424_());
        Vec3 destination = oppositeSurface.m_82399_();
        portal.m_6034_(center.f_82479_, center.f_82480_, center.f_82481_);
        portal.setDestination(destination);
        portal.axisW = Vec3.m_82528_((Vec3i)((Direction)axises.m_14418_()).m_122436_());
        portal.axisH = Vec3.m_82528_((Vec3i)((Direction)axises.m_14419_()).m_122436_());
        portal.width = Helper.getCoordinate(areaSize, ((Direction)axises.m_14418_()).m_122434_());
        portal.height = Helper.getCoordinate(areaSize, ((Direction)axises.m_14419_()).m_122434_());
        portal.dimensionTo = serverWorld.m_46472_();
    }

    public static List<WrappingZone> getWrappingZones(ServerLevel world) {
        GlobalPortalStorage gps = GlobalPortalStorage.get(world);
        ArrayList<WrappingZone> result = new ArrayList<WrappingZone>();
        gps.data.stream().filter(portal -> portal instanceof WorldWrappingPortal).map(portal -> (WorldWrappingPortal)portal).collect(Collectors.groupingBy(portal -> portal.zoneId)).forEach((zoneId, portals) -> result.add(new WrappingZone(world, ((WorldWrappingPortal)portals.get((int)0)).isInward, (int)zoneId, (List<WorldWrappingPortal>)portals)));
        return result;
    }

    public static int getAvailableId(List<WrappingZone> zones) {
        return zones.stream().max(Comparator.comparingInt(z -> z.id)).map(z -> z.id + 1).orElse(1);
    }

    public static void invokeAddWrappingZone(ServerLevel world, int x1, int z1, int x2, int z2, boolean isInward, Consumer<Component> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        for (WrappingZone zone : wrappingZones) {
            if (zone.isValid()) continue;
            feedbackSender.accept((Component)Component.m_237110_((String)"imm_ptl.removed_invalid_wrapping_portals", (Object[])new Object[]{Helper.myToString(zone.portals.stream())}));
            zone.removeFromWorld();
        }
        int availableId = WorldWrappingPortal.getAvailableId(wrappingZones);
        AABB box = new IntBox(new BlockPos(x1, McHelper.getMinY((LevelAccessor)world), z1), new BlockPos(x2, McHelper.getMaxYExclusive((LevelAccessor)world) - 1, z2)).toRealNumberBox();
        WorldWrappingPortal p1 = WorldWrappingPortal.createWrappingPortal(world, box, Direction.NORTH, availableId, isInward);
        WorldWrappingPortal p2 = WorldWrappingPortal.createWrappingPortal(world, box, Direction.SOUTH, availableId, isInward);
        WorldWrappingPortal p3 = WorldWrappingPortal.createWrappingPortal(world, box, Direction.WEST, availableId, isInward);
        WorldWrappingPortal p4 = WorldWrappingPortal.createWrappingPortal(world, box, Direction.EAST, availableId, isInward);
        GlobalPortalStorage gps = GlobalPortalStorage.get(world);
        gps.addPortal(p1);
        gps.addPortal(p2);
        gps.addPortal(p3);
        gps.addPortal(p4);
    }

    public static void invokeViewWrappingZones(ServerLevel world, Consumer<Component> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        wrappingZones.forEach(wrappingZone -> feedbackSender.accept((Component)Component.m_237113_((String)wrappingZone.toString())));
    }

    public static void invokeRemoveWrappingZone(ServerLevel world, Vec3 playerPos, Consumer<Component> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WrappingZone zone = wrappingZones.stream().filter(z -> z.getArea().m_82390_(playerPos)).findFirst().orElse(null);
        if (zone != null) {
            zone.removeFromWorld();
            feedbackSender.accept((Component)Component.m_237110_((String)"imm_ptl.removed_portal", (Object[])new Object[]{zone.toString()}));
        } else {
            feedbackSender.accept((Component)Component.m_237115_((String)"imm_ptl.not_in_wrapping_zone"));
        }
    }

    public static void invokeRemoveWrappingZone(ServerLevel world, int zoneId, Consumer<Component> feedbackSender) {
        List<WrappingZone> wrappingZones = WorldWrappingPortal.getWrappingZones(world);
        WrappingZone zone = wrappingZones.stream().filter(wrappingZone -> wrappingZone.id == zoneId).findFirst().orElse(null);
        if (zone != null) {
            zone.removeFromWorld();
            feedbackSender.accept((Component)Component.m_237110_((String)"imm_ptl.removed_portal", (Object[])new Object[]{zone.toString()}));
        } else {
            feedbackSender.accept((Component)Component.m_237115_((String)"imm_ptl.cannot_find_zone"));
        }
    }

    public static class WrappingZone {
        public ServerLevel world;
        public boolean isInwardZone;
        public int id;
        public List<WorldWrappingPortal> portals;

        public WrappingZone(ServerLevel world, boolean isInwardZone, int id, List<WorldWrappingPortal> portals) {
            this.world = world;
            this.isInwardZone = isInwardZone;
            this.id = id;
            this.portals = portals;
        }

        public boolean isValid() {
            return this.portals.size() == 4 && this.portals.get((int)0).isInward == this.isInwardZone && this.portals.get((int)1).isInward == this.isInwardZone && this.portals.get((int)2).isInward == this.isInwardZone && this.portals.get((int)3).isInward == this.isInwardZone;
        }

        public void removeFromWorld() {
            GlobalPortalStorage gps = GlobalPortalStorage.get(this.world);
            this.portals.forEach(worldWrappingPortal -> gps.removePortal((Portal)worldWrappingPortal));
        }

        public AABB getArea() {
            return this.portals.stream().map(Portal::getThinAreaBox).reduce(AABB::m_82367_).orElse(null);
        }

        public IntBox getIntArea() {
            AABB floatBox = this.getArea();
            return new IntBox(new BlockPos((int)Math.round(floatBox.f_82288_), McHelper.getMinY((LevelAccessor)this.world), (int)Math.round(floatBox.f_82290_)), new BlockPos((int)Math.round(floatBox.f_82291_) - 1, McHelper.getMaxYExclusive((LevelAccessor)this.world), (int)Math.round(floatBox.f_82293_) - 1));
        }

        public IntBox getBorderBox() {
            if (!this.isInwardZone) {
                return this.getIntArea();
            }
            AABB floatBox = this.getArea();
            return new IntBox(new BlockPos((int)Math.round(floatBox.f_82288_) - 1, McHelper.getMinY((LevelAccessor)this.world), (int)Math.round(floatBox.f_82290_) - 1), new BlockPos((int)Math.round(floatBox.f_82291_), McHelper.getMaxYExclusive((LevelAccessor)this.world), (int)Math.round(floatBox.f_82293_)));
        }

        public String toString() {
            AABB area = this.getArea();
            return String.format("[%d] %s %s %s ~ %s %s\n", this.id, this.isInwardZone ? "inward" : "outward", area.f_82288_, area.f_82290_, area.f_82291_, area.f_82293_);
        }
    }
}

